/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import jclass.cell.CellData;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.table3.CellBorder;
import jclass.table3.Clip;
import jclass.table3.JCCell;
import jclass.table3.JCCellDisplayEvent;
import jclass.table3.JCCellRange;
import jclass.table3.JDKSupport;
import jclass.table3.StandardCellBorder;
import jclass.table3.Table;
import jclass.table3.TableDataView;

public class TableCellInfo
implements CellInfo,
Serializable {
    Table table;
    int row;
    int column;
    Clip clip;
    Object cellData;
    CellRenderer cellRenderer;
    boolean isSpanned = false;
    int overflowRow;
    int overflowColumn;
    int cellWidth;
    int cellHeight;
    CellBorder cellBorder;
    int cellBorderSides;
    int cellBorderWidth;
    boolean isSelected;
    Color background;
    Color topShadow;
    Color bottomShadow;
    Graphics gc;
    int str_width;
    int str_height;
    private Rectangle cellBounds = new Rectangle();
    private static Color lastBackground;
    private static Color lastTopShadow;
    private static Color lastBottomShadow;
    private static final Color WHITE_BRIGHTER;
    private static final Color WHITE_DARKER;
    private static final Color BLACK_BRIGHTER;
    private static final Color BLACK_DARKER;
    private static Font cellFont;
    private static FontMetrics cellFontMetrics;
    static Rectangle size;

    TableCellInfo(Table table, Clip clip, int n, int n2) {
        this(table, clip, n, n2, null);
    }

    TableCellInfo(Table table, Clip clip, int n, int n2, Object object) {
        this.table = table;
        this.clip = clip;
        this.row = n;
        this.column = n2;
        TableDataView tableDataView = table.dataView;
        this.cellData = object != null ? object : (n == -1 ? tableDataView.getColumnLabel(n2) : (n2 == -1 ? tableDataView.getRowLabel(n) : tableDataView.getCellData(n, n2)));
        this.cellRenderer = null;
        if (this.cellData instanceof CellData) {
            this.cellRenderer = ((CellData)this.cellData).getRenderer();
            this.cellData = ((CellData)this.cellData).getData();
        }
        if (this.cellRenderer == null) {
            this.cellRenderer = tableDataView.getCellRenderer(n, n2, this.cellData);
        }
        this.cellBorder = table.getCellBorderType(n, n2);
        this.cellBorderSides = table.getCellBorderSides(n, n2);
        this.cellBorderWidth = table.getCellBorderWidth();
        this.isSelected = table.isSelected(n, n2);
        this.background = this.isSelected ? this.getBackgroundColors(this.getSelectedBackground()) : this.getBackgroundColors(table.getBackground(n, n2));
        this.setStringSize();
        this.isSpanned = this.getBounds(this.cellBounds);
        this.cellWidth = this.cellBounds.width;
        this.cellHeight = this.cellBounds.height;
    }

    public Color getBackground() {
        return this.table.getBackground(this.row, this.column);
    }

    public Color getForeground() {
        return this.table.getForeground(this.row, this.column);
    }

    public Color getSelectedBackground() {
        Color color = this.table.getSelectedBackground();
        if (color != null) {
            return color;
        }
        return this.table.getBackground(this.row, this.column);
    }

    public Color getSelectedForeground() {
        Color color = this.table.getSelectedForeground();
        if (color != null) {
            return color;
        }
        return this.table.getForeground(this.row, this.column);
    }

    public Font getFont() {
        Font font = this.table.getFont(this.row, this.column);
        if (font == null) {
            return null;
        }
        if (font != cellFont) {
            cellFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            cellFont = font;
        }
        return cellFont;
    }

    public FontMetrics getFontMetrics() {
        this.getFont();
        return cellFontMetrics;
    }

    public int getHorizontalAlignment() {
        int n = this.table.getAlignment(this.row, this.column);
        switch (n) {
            case 0: 
            case 3: 
            case 6: {
                return 0;
            }
            case 1: 
            case 4: 
            case 7: {
                return 1;
            }
            case 2: 
            case 5: 
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    public int getVerticalAlignment() {
        int n = this.table.getAlignment(this.row, this.column);
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
            case 6: 
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    public Insets getMarginInsets() {
        int n = this.table.getMarginHeight();
        int n2 = this.table.getMarginWidth();
        return new Insets(n, n2, n, n2);
    }

    public Rectangle getDrawingArea() {
        JCCell.getBounds(this.table, null, this.row, this.column, size);
        TableCellInfo.size.width -= this.table.getMarginWidth() * 2 + this.table.getCellBorderWidth() * 2;
        TableCellInfo.size.height -= this.table.getMarginHeight() * 2 + this.table.getCellBorderWidth() * 2;
        TableCellInfo.size.y = 0;
        TableCellInfo.size.x = 0;
        return size;
    }

    public Insets getBorderInsets() {
        int n = this.table.getCellBorderWidth();
        return new Insets(n, n, n, n);
    }

    public int getBorderStyle() {
        return 0;
    }

    public boolean isEditable() {
        return this.table.getEditable(this.row, this.column);
    }

    public boolean isEnabled() {
        return true;
    }

    public Table getTable() {
        return this.table;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean getMultiline() {
        return this.table.getMultiline(this.row, this.column);
    }

    public int getMaxLength() {
        return this.table.getMaxLength(this.row, this.column);
    }

    public int getStringCase() {
        return this.table.getStringCase(this.row, this.column);
    }

    public boolean getSelectAll() {
        return false;
    }

    public int getClipHints() {
        int n = this.table.getClipArrows();
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return 3;
    }

    public Class getDataType() {
        if (this.cellData == null) {
            return this.table.getColumnClass(this.column);
        }
        return this.cellData.getClass();
    }

    final void draw(Graphics graphics, int n, int n2) {
        if (this.table.cellDisplayListeners != null) {
            JCCellDisplayEvent jCCellDisplayEvent = new JCCellDisplayEvent(this.table, this.row, this.column, this.cellData);
            this.table.fireJCCellDisplayEvent(jCCellDisplayEvent);
            this.cellData = jCCellDisplayEvent.getDisplayString();
        }
        if (this.cellData == null) {
            return;
        }
        if (this.row == this.table.edit_row && this.column == this.table.edit_column && this.table.getEditingComponent() != null) {
            return;
        }
        graphics.translate(n, n2);
        this.cellRenderer.draw(graphics, this, this.cellData, this.isSelected);
        graphics.translate(-n, -n2);
    }

    final boolean getBounds(Rectangle rectangle) {
        Dimension dimension;
        JCCellRange jCCellRange;
        if (this.table.span.doSpansExist() && this.table.span.find(this.row, this.column, jCCellRange = new JCCellRange(), dimension = new Dimension()) != -999) {
            this.overflowRow = jCCellRange.start_row;
            this.overflowColumn = jCCellRange.start_column;
            Point point = new Point(0, 0);
            this.table.getPosition(jCCellRange.start_row, jCCellRange.start_column, point);
            JDKSupport.setBounds(rectangle, point.x, point.y, dimension.width, dimension.height);
            return true;
        }
        this.overflowRow = -999;
        this.overflowColumn = -999;
        this.table.getBoundsInternal(this.row, this.column, rectangle);
        return false;
    }

    final Color getBackgroundColors(Color color) {
        if (this.cellBorder instanceof StandardCellBorder) {
            StandardCellBorder standardCellBorder = (StandardCellBorder)this.cellBorder;
            if (standardCellBorder.getBorderType() != 5) {
                if (color.equals(Color.white)) {
                    this.topShadow = WHITE_BRIGHTER;
                    this.bottomShadow = WHITE_DARKER;
                } else if (color.equals(Color.black)) {
                    this.topShadow = BLACK_BRIGHTER;
                    this.bottomShadow = BLACK_DARKER;
                } else if (color == lastBackground) {
                    this.topShadow = lastTopShadow;
                    this.bottomShadow = lastBottomShadow;
                } else {
                    if (this.table.cellBorderColor == null) {
                        this.topShadow = color.brighter();
                        this.bottomShadow = color.darker();
                    } else {
                        this.topShadow = this.table.cellBorderBrighter;
                        this.bottomShadow = this.table.cellBorderDarker;
                    }
                    lastBackground = color;
                    lastTopShadow = this.topShadow;
                    lastBottomShadow = this.bottomShadow;
                }
            } else {
                this.topShadow = this.bottomShadow = this.table.getForeground(this.row, this.column);
            }
        } else {
            this.topShadow = this.bottomShadow = this.table.getForeground(this.row, this.column);
        }
        return color;
    }

    final void setStringSize() {
        this.str_width = 0;
        this.str_height = 0;
        if (this.cellData == null) {
            return;
        }
        Dimension dimension = this.cellRenderer.getPreferredSize(this, this.cellData);
        if (dimension == null) {
            FontMetrics fontMetrics = this.getFontMetrics();
            this.str_width = TableCellInfo.getWidth(fontMetrics, this.cellData.toString());
            this.str_height = TableCellInfo.getHeight(fontMetrics, this.cellData.toString());
            return;
        }
        this.str_width = dimension.width;
        this.str_height = dimension.height;
    }

    private static final int getHeight(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        return fontMetrics.getHeight() * n;
    }

    private static final int getWidth(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.indexOf(10) != -1) {
            int n;
            int n2 = 0;
            int n3 = 0;
            while ((n = string.indexOf(10, n2)) != -1) {
                n3 = Math.max(n3, fontMetrics.stringWidth(string.substring(n2, n)));
                n2 = n + 1;
            }
            return Math.max(n3, fontMetrics.stringWidth(string.substring(n2, string.length())));
        }
        return fontMetrics.stringWidth(string);
    }

    static {
        WHITE_BRIGHTER = new Color(200, 200, 200);
        WHITE_DARKER = new Color(140, 140, 140);
        BLACK_BRIGHTER = new Color(125, 125, 125);
        BLACK_DARKER = new Color(75, 75, 75);
        size = new Rectangle();
    }
}

